/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.item;

import java.util.EnumMap;
import java.util.List;
import technology.rocketjump.undermount.assets.entities.item.ItemEntityAssetsByStyle;
import technology.rocketjump.undermount.assets.entities.item.model.ItemEntityAsset;
import technology.rocketjump.undermount.assets.entities.item.model.ItemPlacement;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;

public class ItemEntityAssetsByPlacement {
    private EnumMap<ItemPlacement, ItemEntityAssetsByStyle> byItemPlacement = new EnumMap(ItemPlacement.class);

    public ItemEntityAssetsByPlacement() {
        for (ItemPlacement iItemPlacement : ItemPlacement.values()) {
            this.byItemPlacement.put(iItemPlacement, new ItemEntityAssetsByStyle());
        }
    }

    public void add(ItemEntityAsset asset) {
        List<ItemPlacement> itemPlacements = asset.getItemPlacements();
        if (itemPlacements == null || itemPlacements.isEmpty()) {
            for (ItemPlacement itemPlacement : ItemPlacement.values()) {
                this.byItemPlacement.get((Object)itemPlacement).add(asset);
            }
        } else {
            for (ItemPlacement itemPlacement : itemPlacements) {
                this.byItemPlacement.get((Object)itemPlacement).add(asset);
            }
        }
    }

    public ItemEntityAsset get(ItemEntityAttributes attributes) {
        ItemPlacement itemPlacement = attributes.getItemPlacement();
        if (itemPlacement == null) {
            itemPlacement = ItemPlacement.ON_GROUND;
        }
        return this.byItemPlacement.get((Object)itemPlacement).get(attributes);
    }

    public List<ItemEntityAsset> getAll(ItemEntityAttributes attributes) {
        ItemPlacement itemPlacement = attributes.getItemPlacement();
        if (itemPlacement == null) {
            itemPlacement = ItemPlacement.ON_GROUND;
        }
        return this.byItemPlacement.get((Object)itemPlacement).getAll(attributes);
    }
}

